library ieee;
use ieee.std_logic_1164.all;
use work.all;

architecture logic of fifo is

-- generated by Concept HDL Direct Version 2.0 09-May-95
-- on Tue Oct 31 16:13:40 1995
-- from /usr2/work/tpcae/examples/cadence/example12/source/fifo/logic

  component lpm_add_sub
-- derived from
-- file /usr/maxplus2/simlib/concept/alt_lpm/lpm_add_sub/entity/vhdl.vhd
  generic (lpm_direction:string;
    lpm_rep:string;
    lpm_width:positive;
    polar_add_sub:string;
    polar_cin:string;
    polar_cout:string;
    polar_dataa:string;
    polar_datab:string;
    polar_overflow:string;
    polar_result:string  );
  port (cout:out std_logic ;
    overflow:out std_logic ;
    result:out std_logic_vector (LPM_WIDTH - 1 downto 0);
    add_sub:in std_logic ;
    cin:in std_logic ;
    dataa:in std_logic_vector (LPM_WIDTH - 1 downto 0);
    datab:in std_logic_vector (LPM_WIDTH - 1 downto 0)  );
  end component;

  component lpm_and2
-- derived from
-- file /usr/maxplus2/simlib/concept/alt_lpm/lpm_and2/entity/vhdl.vhd
  generic (lpm_size:positive;
    lpm_width:positive;
    polar_data0x:string;
    polar_data1x:string;
    polar_result:string  );
  port (result:out std_logic_vector (LPM_WIDTH - 1 downto 0);
    data0x:in std_logic_vector (LPM_WIDTH - 1 downto 0);
    data1x:in std_logic_vector (LPM_WIDTH - 1 downto 0)  );
  end component;

  component lpm_compare
-- derived from
-- file /usr/maxplus2/simlib/concept/alt_lpm/lpm_compare/entity/vhdl.vhd
  generic (lpm_rep:string;
    lpm_width:positive;
    polar_aeb:string;
    polar_agb:string;
    polar_ageb:string;
    polar_alb:string;
    polar_aleb:string;
    polar_aneb:string;
    polar_dataa:string;
    polar_datab:string  );
  port (aeb:out std_logic ;
    agb:out std_logic ;
    ageb:out std_logic ;
    alb:out std_logic ;
    aleb:out std_logic ;
    aneb:out std_logic ;
    dataa:in std_logic_vector (LPM_WIDTH - 1 downto 0);
    datab:in std_logic_vector (LPM_WIDTH - 1 downto 0)  );
  end component;

  component lpm_counter
-- derived from
-- file /usr/maxplus2/simlib/concept/alt_lpm/lpm_counter/entity/vhdl.vhd
  generic (lpm_avalue:positive;
    lpm_direction:string;
    lpm_modulus:positive;
    lpm_representation:string;
    lpm_svalue:positive;
    lpm_width:positive;
    polar_aconst:string;
    polar_aload:string;
    polar_aset:string;
    polar_clk_en:string;
    polar_clock:string;
    polar_cnt_en:string;
    polar_data:string;
    polar_eq:string;
    polar_q:string;
    polar_sclr:string;
    polar_sconst:string;
    polar_sload:string;
    polar_sset:string;
    polar_updown:string  );
  port (eq:out std_logic_vector (LPM_MODULUS - 1 downto 0);
    q:out std_logic_vector (LPM_WIDTH - 1 downto 0);
    aclr:in std_logic ;
    aconst:in std_logic ;
    aload:in std_logic ;
    aset:in std_logic ;
    clk_en:in std_logic ;
    clock:in std_logic ;
    cnt_en:in std_logic ;
    data:in std_logic_vector (LPM_WIDTH - 1 downto 0);
    sclr:in std_logic ;
    sconst:in std_logic ;
    sload:in std_logic ;
    sset:in std_logic ;
    updown:in std_logic   );
  end component;

  component lpm_mux2
-- derived from
-- file /usr/maxplus2/simlib/concept/alt_lpm/lpm_mux2/entity/vhdl.vhd
  generic (lpm_size:positive;
    lpm_width:positive;
    lpm_widths:positive;
    polar_data0x:string;
    polar_data1x:string;
    polar_result:string;
    polar_sel:string  );
  port (result:out std_logic_vector (LPM_WIDTH - 1 downto 0);
    data0x:in std_logic_vector (LPM_WIDTH - 1 downto 0);
    data1x:in std_logic_vector (LPM_WIDTH - 1 downto 0);
    sel:in std_logic_vector (LPM_WIDTHS - 1 downto 0)  );
  end component;

  component lpm_ram_dq
-- derived from
-- file /usr/maxplus2/simlib/concept/alt_lpm/lpm_ram_dq/entity/vhdl.vhd
  generic (lpm_addr_control:string;
    lpm_file:string;
    lpm_indata:string;
    lpm_numwords:positive;
    lpm_outdata:string;
    lpm_width:positive;
    lpm_widthad:positive;
    polar_address:string;
    polar_data:string;
    polar_inclock:string;
    polar_outclock:string;
    polar_q:string;
    polar_we:string  );
  port (q:out std_logic_vector (LPM_WIDTH - 1 downto 0);
    address:in std_logic_vector (LPM_WIDTHAD - 1 downto 0);
    data:in std_logic_vector (LPM_WIDTH - 1 downto 0);
    inclock:in std_logic ;
    outclock:in std_logic ;
    we:in std_logic   );
  end component;

  -- port clk: in std_logic ;
  -- port clock2x: in std_logic ;
  -- port d: in std_logic_vector (7 downto 0);
  -- port fifo_out: out std_logic_vector (7 downto 0);
  -- port read: in std_logic ;
  -- port write: in std_logic ;
  -- global supply_0: std_logic ;
  -- global supply_1: std_logic ;
  signal add: std_logic_vector (7 downto 0);
  signal cnt1: std_logic_vector (7 downto 0);
  signal cnt2: std_logic_vector (7 downto 0);
  signal mux: std_logic_vector (7 downto 0);
  signal unnamed_1_lpm_and2_i4_data1x: std_logic ;
  signal unnamed_1_lpm_and2_i4_result: std_logic ;
  signal unnamed_1_lpm_and2_i5_data0x: std_logic ;
  signal unnamed_1_lpm_and2_i5_result: std_logic ;
  signal unnamed_1_lpm_and2_i8_data0x: std_logic ;

begin

p1: block

begin
  i4: lpm_and2 
	generic map (lpm_size => 2,
	lpm_width => 1,
	polar_data0x => "INVERT",
	polar_data1x => "NORMAL",
	polar_result => "NORMAL")
	port map (data0x (0  ) => clk ,
	data1x (0  ) => unnamed_1_lpm_and2_i4_data1x ,
	result (0  ) => unnamed_1_lpm_and2_i4_result );
  i5: lpm_and2 
	generic map (lpm_size => 2,
	lpm_width => 1,
	polar_data0x => "INVERT",
	polar_data1x => "NORMAL",
	polar_result => "NORMAL")
	port map (data0x (0  ) => unnamed_1_lpm_and2_i5_data0x ,
	data1x (0  ) => read ,
	result (0  ) => unnamed_1_lpm_and2_i5_result );
  i8: lpm_and2 
	generic map (lpm_size => 2,
	lpm_width => 1,
	polar_data0x => "INVERT",
	polar_data1x => "NORMAL",
	polar_result => "NORMAL")
	port map (data0x (0  ) => unnamed_1_lpm_and2_i8_data0x ,
	data1x (0  ) => write ,
	result (0  ) => unnamed_1_lpm_and2_i4_data1x );
  i9: lpm_compare 
	generic map (lpm_rep => "UNSIGNED",
	lpm_width => 8,
	polar_aeb => "NORMAL",
	polar_agb => "NORMAL",
	polar_ageb => "NORMAL",
	polar_alb => "NORMAL",
	polar_aleb => "NORMAL",
	polar_aneb => "NORMAL",
	polar_dataa => "NORMAL",
	polar_datab => "NORMAL")
	port map (aeb  => unnamed_1_lpm_and2_i8_data0x ,
	agb  => open ,
	ageb  => open ,
	alb  => open ,
	aleb  => open ,
	aneb  => open ,
	dataa  => cnt1 (7 downto 0),
	datab  => add (7 downto 0));
  i12: lpm_counter 
	generic map (lpm_avalue => 0,
	lpm_direction => "UP",
	lpm_modulus => 1<<8,
	lpm_representation => open,
	lpm_svalue => 0,
	lpm_width => 8,
	polar_aconst => "NORMAL",
	polar_aload => "NORMAL",
	polar_aset => "NORMAL",
	polar_clk_en => "NORMAL",
	polar_clock => "NORMAL",
	polar_cnt_en => "NORMAL",
	polar_data => "NORMAL",
	polar_eq => "NORMAL",
	polar_q => "NORMAL",
	polar_sclr => "NORMAL",
	polar_sconst => "NORMAL",
	polar_sload => "NORMAL",
	polar_sset => "NORMAL",
	polar_updown => "NORMAL")
	port map (aclr  => open ,
	aconst  => open ,
	aload  => open ,
	aset  => open ,
	clk_en  => open ,
	clock  => clk ,
	cnt_en  => unnamed_1_lpm_and2_i5_result ,
	data  => open ,
	eq  => open ,
	q  => cnt1 (7 downto 0),
	sclr  => open ,
	sconst  => open ,
	sload  => open ,
	sset  => open ,
	updown  => open );
  i13: lpm_compare 
	generic map (lpm_rep => "UNSIGNED",
	lpm_width => 8,
	polar_aeb => "NORMAL",
	polar_agb => "NORMAL",
	polar_ageb => "NORMAL",
	polar_alb => "NORMAL",
	polar_aleb => "NORMAL",
	polar_aneb => "NORMAL",
	polar_dataa => "NORMAL",
	polar_datab => "NORMAL")
	port map (aeb  => unnamed_1_lpm_and2_i5_data0x ,
	agb  => open ,
	ageb  => open ,
	alb  => open ,
	aleb  => open ,
	aneb  => open ,
	dataa  => cnt1 (7 downto 0),
	datab  => cnt2 (7 downto 0));
  i19: lpm_mux2 
	generic map (lpm_size => 2,
	lpm_width => 8,
	lpm_widths => 1,
	polar_data0x => "NORMAL",
	polar_data1x => "NORMAL",
	polar_result => "NORMAL",
	polar_sel => "NORMAL")
	port map (data0x  => cnt2 (7 downto 0),
	data1x  => cnt1 (7 downto 0),
	result  => mux (7 downto 0),
	sel (0  ) => clk );
  i21: lpm_ram_dq 
	generic map (lpm_addr_control => "UNREGISTERED",
	lpm_file => "UNUSED",
	lpm_indata => "REGISTERED",
	lpm_numwords => 1<<8,
	lpm_outdata => "REGISTERED",
	lpm_width => 8,
	lpm_widthad => 8,
	polar_address => "NORMAL",
	polar_data => "NORMAL",
	polar_inclock => "NORMAL",
	polar_outclock => "NORMAL",
	polar_q => "NORMAL",
	polar_we => "NORMAL")
	port map (address  => mux (7 downto 0),
	data  => d (7 downto 0),
	inclock  => clock2x ,
	outclock  => clk ,
	q  => fifo_out (7 downto 0),
	we  => unnamed_1_lpm_and2_i4_result );
  i26: lpm_counter 
	generic map (lpm_avalue => 0,
	lpm_direction => "UP",
	lpm_modulus => 1<<8,
	lpm_representation => open,
	lpm_svalue => 0,
	lpm_width => 8,
	polar_aconst => "NORMAL",
	polar_aload => "NORMAL",
	polar_aset => "NORMAL",
	polar_clk_en => "NORMAL",
	polar_clock => "NORMAL",
	polar_cnt_en => "NORMAL",
	polar_data => "NORMAL",
	polar_eq => "NORMAL",
	polar_q => "NORMAL",
	polar_sclr => "NORMAL",
	polar_sconst => "NORMAL",
	polar_sload => "NORMAL",
	polar_sset => "NORMAL",
	polar_updown => "NORMAL")
	port map (aclr  => open ,
	aconst  => open ,
	aload  => open ,
	aset  => open ,
	clk_en  => open ,
	clock  => clk ,
	cnt_en  => unnamed_1_lpm_and2_i4_data1x ,
	data  => open ,
	eq  => open ,
	q  => cnt2 (7 downto 0),
	sclr  => open ,
	sconst  => open ,
	sload  => open ,
	sset  => open ,
	updown  => open );
  i27: lpm_add_sub 
	generic map (lpm_direction => "UNUSED",
	lpm_rep => "SIGNED",
	lpm_width => 8,
	polar_add_sub => "NORMAL",
	polar_cin => "NORMAL",
	polar_cout => "NORMAL",
	polar_dataa => "NORMAL",
	polar_datab => "NORMAL",
	polar_overflow => "NORMAL",
	polar_result => "NORMAL")
	port map (add_sub  => open ,
	cin  => supply_1 ,
	cout  => open ,
	dataa  => cnt2 (7 downto 0),
	datab (0  ) => supply_0 ,
	datab (1  ) => supply_0 ,
	datab (2  ) => supply_0 ,
	datab (3  ) => supply_0 ,
	datab (4  ) => supply_0 ,
	datab (5  ) => supply_0 ,
	datab (6  ) => supply_0 ,
	datab (7  ) => supply_0 ,
	overflow  => open ,
	result  => add (7 downto 0));
end block p1;
end logic ;
